using System;

namespace FrilenseriSharp
{
    class Program
    {
        struct Frilenser
        {
            public int plata;
            public double procenat;
        }

        static void SelectionSort(Frilenser[] frilenseri, int dimenzija)
        {
            int i, indeksMin;
            for (i = 0; i < dimenzija - 1; i++)
            {
                indeksMin = IndeksMin(frilenseri, dimenzija, i);
                razmeni(ref frilenseri[i], ref frilenseri[indeksMin]);
            }
        }

        static int IndeksMin(Frilenser[] frilenseri, int dimenzija, int i)
        {
            int indeksMin = i;
            for (int j = i + 1; j < dimenzija; j++)
            {
                if (frilenseri[j].procenat < frilenseri[indeksMin].procenat)
                {
                    indeksMin = j;
                }

            }
            return indeksMin;
        }
        static void razmeni(ref Frilenser x, ref Frilenser y)
        {
            Frilenser p = x;
            x = y;
            y = p;
        }
        static void Main(string[] args)
        {
            int n, i;
            long zarada=0;
            string unos;
            string[] vrednosti;
            double max=0, suma;
            n = int.Parse(Console.ReadLine());
            Frilenser[] frilenseri = new Frilenser[n];
            for (i = 0; i < n; i++)
            {
                unos = Console.ReadLine();
                vrednosti = unos.Split(' ');
                frilenseri[i].plata = int.Parse(vrednosti[0]);
                frilenseri[i].procenat = double.Parse(vrednosti[1]);
                zarada += frilenseri[i].plata;
            }
            SelectionSort(frilenseri, n);
            max = zarada * frilenseri[0].procenat / 100;
            zarada -= frilenseri[0].plata;
            for (i=1;i<n;i++)
            {
                suma = zarada * frilenseri[i].procenat/100;
                if(suma>max)
                {
                    max = suma;
                }
                zarada -= frilenseri[i].plata;
            }
            Console.WriteLine(max);
        }
    }
}